import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
road_condition_index = [1, 12, 28, 93]
fuel_efficiency_model_a = [20, 25, 30, 35]
fuel_efficiency_model_b = [28, 28, 28, 28]

# Axes Limits and Labels
xlabel_value = "Road Condition Index"
xlim_values = [-5, 95]
xticks_values = np.arange(0, 101, 20)

ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [18, 36]
yticks_values = np.arange(20, 36, 2)

# Labels
label_model_a = "Model A"
label_model_b = "Model B"
label_model_c = "Model C"
label_model_d = "Model D"

# Titles
title_1 = "Fuel Efficiency vs. Road Condition"
title_2 = "Vehicle Models"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the line that we will manipulate
fig, ax = plt.subplots(figsize=(8, 6))
ax.plot(
    road_condition_index,
    fuel_efficiency_model_a,
    marker="o",
    color="orange",
    linewidth=2,
    markersize=6,
    markerfacecolor="orange",
    label=label_model_a,
)

# Extend the Model B line visually by adding extra points
extended_x = [-5] + road_condition_index + [95]  # Extend x-axis data points
extended_y = [28] * (len(fuel_efficiency_model_b) + 2)  # Extend y-axis data points to match
ax.plot(
    extended_x, extended_y, linestyle="--", color="#202020", label=label_model_b
)  # Plot the extended line

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values, fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit

# Set the title and labels
ax.set_title(title_1, fontsize=20)
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Add a legend with a title
ax.legend(
    title=title_2,
    loc="lower right",
    fontsize=12,
    title_fontsize=12,
    edgecolor="#fdfdfd",
)

# Change the plot background color
ax.set_facecolor("#f5f5f5")

# Show grid with lighter color
ax.grid(True, color="#fcfcfc", linewidth=1.5)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#ffffff")
ax.spines["top"].set_color("#ffffff")  # Optional: hide or set color
ax.spines["left"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig('line_32.pdf', bbox_inches='tight')
