import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
cargo_ratios = np.array([0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0])
model_a_efficiency = np.array([30, 28, 27, 25, 23, 22, 21, 20, 19, 18])
model_b_efficiency = np.array([35, 33, 31, 30, 28, 27, 25, 24, 23, 22])
model_a_std = np.array([1.5] * 10)
model_b_std = np.array([2.0] * 10)

# Axes Limits and Labels
xlabel_value = "Cargo Load Ratio"
xlim_values = [0.05, 1.05]
xticks_values = np.arange(0.1, 1.1, 0.1)

ylabel_value = "Fuel Efficiency (MPG)"
yticks_values_1 = np.arange(15, 36, 5)
ylim_values_1 = [15, 36]
yticks_values_2 = np.arange(15, 36, 5)
ylim_values_2 = [15, 36]
yticks_values_3 = np.arange(15, 36, 5)
ylim_values_3 = [15, 36]

# Labels
labels = ["Model A", "Model B"]

# Titles
titles = ["Highway Driving", "City Driving", "Off-Road Driving"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot settings
fig, axs = plt.subplots(1, 3, figsize=(15, 5))
colors = ["#9467bd", "#ff7f0e"]
markers = ["s", "o"]  # Square and circle markers

for i, ax in enumerate(axs):
    ax.plot(
        cargo_ratios, model_a_efficiency, label=labels[0], color=colors[0], marker=markers[0]
    )
    ax.fill_between(
        cargo_ratios,
        model_a_efficiency - model_a_std,
        model_a_efficiency + model_a_std,
        color=colors[0],
        alpha=0.2,
    )
    ax.plot(
        cargo_ratios, model_b_efficiency, label=labels[1], color=colors[1], marker=markers[1]
    )
    ax.fill_between(
        cargo_ratios,
        model_b_efficiency - model_b_std,
        model_b_efficiency + model_b_std,
        color=colors[1],
        alpha=0.2,
    )
    ax.set_xticks(xticks_values)
    ax.set_xlim(xlim_values)
    ax.set_title(titles[i])
    ax.set_xlabel(xlabel_value)
    ax.grid(True)

# Adjust subplot layout
plt.subplots_adjust(wspace=0.3)

axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)
axs[2].set_yticks(yticks_values_3)
axs[2].set_ylim(ylim_values_3)

# Move legend inside the plot area
axs[0].legend(loc="upper left")
axs[1].legend(loc="lower right")
axs[2].legend(loc="lower left")

# Adjust y-axis label to match reference picture
axs[0].set_ylabel(ylabel_value)
axs[1].set_ylabel(ylabel_value)
axs[2].set_ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('line_36.pdf', bbox_inches='tight')
