import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for each subplot
speeds = [20, 40, 60, 80, 100]
fuel_efficiency_a = [30, 28, 27, 25, 24]  # Example data for Model A
fuel_efficiency_b = [28, 26, 23, 20, 18]  # Example data for Model B
fuel_efficiency_c = [24, 22, 19, 16, 14]  # Example data for Model C
fuel_efficiency_d = [20, 18, 15, 12, 11]  # Example data for Model D

# Axes Limits and Labels
xlim_values = [15, 105]
xticks_values = speeds

ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [10, 35]
yticks_values = np.arange(10, 36, 5)


# Labels
label_a = "Model A"
label_b = "Model B"
label_c = "Model C"
label_d = "Model D"

# Titles
datasets = ["Dataset 1", "Dataset 2", "Dataset 3", "Dataset 4"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 4, figsize=(15, 4))

# Plot data on each subplot
axs[0].plot(speeds, fuel_efficiency_a, "o--", label=label_a, color="#4c92c3", markersize=10)
axs[0].plot(speeds, fuel_efficiency_b, "^--", label=label_b, color="#ff993e", markersize=10)
axs[0].plot(speeds, fuel_efficiency_c, "s--", label=label_c, color="#56b356", markersize=10)
axs[0].plot(speeds, fuel_efficiency_d, "*--", label=label_d, color="#de5253", markersize=10)
axs[0].set_xticks(xticks_values)
axs[0].set_title(datasets[0], fontsize=14)
axs[0].set_ylabel(ylabel_value, fontsize=14)
axs[0].set_yticks(yticks_values)
axs[0].set_ylim(ylim_values)

axs[1].plot(speeds, fuel_efficiency_a, "o--", label=label_a, color="#4c92c3", markersize=10)
axs[1].plot(speeds, fuel_efficiency_b, "^--", label=label_b, color="#ff993e", markersize=10)
axs[1].plot(speeds, fuel_efficiency_c, "s--", label=label_c, color="#56b356", markersize=10)
axs[1].plot(speeds, fuel_efficiency_d, "*--", label=label_d, color="#de5253", markersize=10)
axs[1].set_xticks(xticks_values)
axs[1].set_title(datasets[1], fontsize=14)
axs[1].set_ylabel(ylabel_value, fontsize=14)
axs[1].set_yticks(yticks_values)
axs[1].set_ylim(ylim_values)

axs[2].plot(speeds, fuel_efficiency_a, "o--", label=label_a, color="#4c92c3", markersize=10)
axs[2].plot(speeds, fuel_efficiency_b, "^--", label=label_b, color="#ff993e", markersize=10)
axs[2].plot(speeds, fuel_efficiency_c, "s--", label=label_c, color="#56b356", markersize=10)
axs[2].plot(speeds, fuel_efficiency_d, "*--", label=label_d, color="#de5253", markersize=10)
axs[2].set_xticks(xticks_values)
axs[2].set_title(datasets[2], fontsize=14)
axs[2].set_ylabel(ylabel_value, fontsize=14)
axs[2].set_yticks(yticks_values)
axs[2].set_ylim(ylim_values)

axs[3].plot(speeds, fuel_efficiency_a, "o--", label=label_a, color="#4c92c3", markersize=10)
axs[3].plot(speeds, fuel_efficiency_b, "^--", label=label_b, color="#ff993e", markersize=10)
axs[3].plot(speeds, fuel_efficiency_c, "s--", label=label_c, color="#56b356", markersize=10)
axs[3].plot(speeds, fuel_efficiency_d, "*--", label=label_d, color="#de5253", markersize=10)
axs[3].set_xticks(xticks_values)
axs[3].set_title(datasets[3], fontsize=14)
axs[3].set_ylabel(ylabel_value, fontsize=14)
axs[3].set_yticks(yticks_values)
axs[3].set_ylim(ylim_values)

plt.legend(loc="center", bbox_to_anchor=(-1.6, -0.2), ncol=4, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig('line_39.pdf', bbox_inches='tight')
