import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
car_types = ["Sedan", "SUV", "Truck", "Minivan"]  # Update for categorical x-axis
car_types_int = [0, 1, 2, 3]
city_mpg = [30, 20, 15, 22]
highway_mpg = [40, 25, 20, 28]
city_mpg_hybrid = [45, 35, 25, 32]
highway_mpg_hybrid = [50, 40, 30, 38]

# Axes Limits and Labels
xticks_values = range(len(car_types))
ylabel_value = "Miles per Gallon (MPG)"

# Labels
label_1 = "City MPG"
label_2 = "Highway MPG"

# Titles
title_1 = "Regular Engines"
title_2 = "Hybrid Engines"

# Texts
text_1 = "50% increase"
text_2 = "45% increase"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(9, 4))

# Plotting for Regular Engines
ax1.set_xticks(xticks_values)  # Setting categorical x-axis
ax1.plot(
    car_types,
    city_mpg,
    marker="o",
    color="#f5a45f",
    label=label_1,
    linewidth=4,
    markersize=8,
)
ax1.plot(
    car_types,
    highway_mpg,
    marker="o",
    linestyle="--",
    color="#f5a45f",
    label=label_2,
    linewidth=4,
    markersize=8,
)
ax1.set_title(title_1, fontsize=16)
ax1.set_ylabel(ylabel_value, fontsize=16)  # Adjusted font size
ax1.legend(loc="lower left", fontsize=14)
ax1.set_xticklabels(car_types, fontsize=12)  # Adjust font size for x-axis labels
ax1.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax1.annotate(
    "",
    xy=(0, city_mpg[0]),
    xytext=(0, highway_mpg[0]),
    arrowprops=dict(color="red", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax1.text(
    0.1,
    (city_mpg[0] + highway_mpg[0]) / 2,
    text_1,
    ha="left",
    va="center",
    fontsize=14,
    color="black",
)

# Plotting for Hybrid Engines
ax2.plot(
    car_types,
    city_mpg_hybrid,
    marker="o",
    color="#3ebcec",
    label=label_1,
    linewidth=4,
    markersize=8,
)
ax2.plot(
    car_types,
    highway_mpg_hybrid,
    marker="o",
    linestyle="--",
    color="#3ebcec",
    label=label_2,
    linewidth=4,
    markersize=8,
)
ax2.set_title(title_2, fontsize=16)  # Adjusted font size
ax2.legend(loc="lower left", fontsize=14)
ax2.set_xticklabels(
    car_types, fontsize=12
)  # Ensure x-axis labels are set for both axes
ax2.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax2.annotate(
    "",
    xy=(0, city_mpg_hybrid[0]),
    xytext=(0, highway_mpg_hybrid[0]),
    arrowprops=dict(color="red", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax2.text(
    0.1,
    (city_mpg_hybrid[0] + highway_mpg_hybrid[0]) / 2,
    text_2,
    ha="left",
    va="center",
    fontsize=14,
    color="black",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and add common annotation for car types
plt.tight_layout()
plt.savefig('line_4.pdf', bbox_inches='tight')
