import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# New generated data
budget_values = np.array([10.,32.5,55.,77.5,100.])  # Advertising budget in thousands
sales_growth_tv = np.array([28.82, 22.00, 24.89, 31.20, 29.33])
sales_growth_online = np.array([47.64, 34.00, 39.78, 52.40, 48.67])
sales_growth_print = np.array([5.11, 14.75, 9.24, 9.48, 12.05])
sales_growth_total = np.array([40.72, 47.27, 43.80, 40.60, 42.21])

# Labels and Plot Types
label_tv = "TV Advertising"
label_online = "Online Advertising"
label_print = "Print Advertising"
label_total = "Total Sales Growth"

# Axes Limits and Labels
yticks_values = np.arange(0, 85, 10)
ylim_values = [0, 85]
xlabel_value = "Advertising Budget (in $1000s)"
ylabel_value = "Sales Growth (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting with error bars (second-level element)
plt.figure(figsize=(8, 6))  # Increased figure size for clarity
plt.plot(budget_values, sales_growth_tv, "-o", label=label_tv, color="#1f77b4")
plt.fill_between(budget_values, sales_growth_tv - 5, sales_growth_tv + 5, color="#1f77b4", alpha=0.2)
plt.plot(budget_values, sales_growth_online, "-^", label=label_online, color="#ff7f0e")
plt.fill_between(
    budget_values, sales_growth_online - 10, sales_growth_online + 10, color="#ff7f0e", alpha=0.2
)
plt.plot(budget_values, sales_growth_print, "-x", label=label_print, color="#2ca02c")
plt.fill_between(
    budget_values, sales_growth_print - 5, sales_growth_print + 5, color="#2ca02c", alpha=0.2
)
plt.plot(budget_values, sales_growth_total, "-s", label=label_total, color="#d62728")
plt.fill_between(budget_values, sales_growth_total - 5, sales_growth_total + 5, color="#d62728", alpha=0.2)

# Customizing axes and labels (third-level elements)
plt.yticks(yticks_values, fontsize=12)
plt.xticks(fontsize=12)
plt.ylim(ylim_values)
plt.grid(True)

# Relocating the legend to ensure no overlap with data lines
plt.legend(loc="lower right", frameon=True, shadow=True, fontsize=10)

# Customizing the background (third-level element)
plt.gca().set_facecolor("#f4f4f5")
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# Labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('line_40.pdf', bbox_inches='tight')
