import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Simulated data
modes_x = np.array(
    ["All", "Car", "Bus", "Train", "Bike", "Walking", "E-scooter", "Taxi"]
)
travel_time_y = np.array([30, 35, 40, 50, 25, 20, 30, 40])
travel_time_err = np.array([2, 3, 1, 1, 2, 2, 3, 2])
travel_time_y2 = np.array(
    [32, 37, 42, 52, 27, 22, 32, 42]
)  # Adjusted data for clear spacing
travel_time_err2 = np.array([3, 3, 1, 2, 2, 3, 3, 4])

delay_x = np.array(
    ["All", "Car", "Bus", "Train", "Bike", "Walking", "E-scooter", "Taxi"]
)
delay_y = np.array([25, 27, 30, 35, 23, 22, 25, 28])
delay_err = np.array([1, 2, 1, 2, 1, 1, 2, 1])
delay_y2 = np.array([26, 28, 32, 38, 24, 23, 26, 29])  # Adjusted data for clear spacing
delay_err2 = np.array([2, 3, 1, 1, 2, 2, 3, 2])

# Axes Limits and Labels
ylabel_value = "Average Travel Time (min)"
ylim_values = [15, 55]
yticks_values = np.arange(15, 56, 5)

# Labels
label_1 = "Travel Time 2022"
label_2 = "Travel Time 2023"
label_3 = "Delay 2022"
label_4 = "Delay 2023"

# Titles
title_1 = "Average Travel Time Results"
title_2 = "Average Delay Results"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot layout of 1x2
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5), sharey=True)

# First subplot for Travel Time
ax1.errorbar(
    modes_x,
    travel_time_y,
    yerr=travel_time_err,
    fmt="o-",
    label=label_1,
    color="#3d89be",
    capsize=5,
)
ax1.errorbar(
    modes_x,
    travel_time_y2,
    yerr=travel_time_err2,
    fmt="^-",
    label=label_2,
    color="#00BFFF",
    capsize=5,
)
ax1.set_title(title_1)
ax1.set_xticks(modes_x)
ax1.set_xticklabels(modes_x, rotation=45, ha="right", fontsize=12)
ax1.set_yticks(yticks_values)
ax1.set_ylim(ylim_values)
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="lower left", fontsize=12)

# Second subplot for Delay
ax2.errorbar(
    delay_x,
    delay_y,
    yerr=delay_err,
    fmt="s--",
    label=label_3,
    color="#ff7f0e",
    capsize=5,
)
ax2.errorbar(
    delay_x,
    delay_y2,
    yerr=delay_err2,
    fmt="o-.",
    label=label_4,
    color="#FFA500",
    capsize=5,
)
ax2.set_title(title_2)
ax2.set_xticks(delay_x)
ax2.set_xticklabels(delay_x, rotation=45, ha="right", fontsize=12)
ax2.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax2.legend(loc="upper left", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout
plt.tight_layout()
plt.savefig('line_43.pdf', bbox_inches='tight')
