import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting, using random noise to add variability
vehicles = np.array([10, 20, 30, 40, 50, 60])
fuel_efficiency = np.array([929.81, 605.38, 824.61, 937.48, 1173.87, 740.51])  # miles per gallon
maintenance_cost = np.array([1156.38, 1837.66, 1945.49, 1075.16, 1687.59, 1293.34])  # dollars per year

# New random data for variability
carbon_emissions = np.array([602.37, 352.08, 950.27, 939.01, 985.85, 417.17])  # grams per mile
operational_costs = np.array([4112.63, 4480.05, 4914.47, 4196.63, 2845.92, 4122.12])  # dollars per year

# Axes Limits and Labels
xlabel_value = "Number of Vehicles"

ylabel_value = "Values"

# Labels
label_Fuel_Efficiency = "Fuel Efficiency (MPG)"
label_Maintenance_Cost = "Maintenance Cost ($/year)"
label_Carbon_Emissions = "Carbon Emissions (g/mile)"
label_Operational_Costs = "Operational Costs ($/year)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data using different styles and colors
plt.plot(
    vehicles,
    fuel_efficiency,
    "o-",
    color="#1f77b4",
    label=label_Fuel_Efficiency,
    markerfacecolor="#1f77b4",
    markersize=8,
    linewidth=2,
)
plt.plot(
    vehicles,
    maintenance_cost,
    "x-",
    color="#ff7f0e",
    label=label_Maintenance_Cost,
    markersize=8,
    linewidth=2,
)
plt.plot(
    vehicles,
    carbon_emissions,
    "s--",
    color="green",
    label=label_Carbon_Emissions,
    markersize=8,
    linewidth=2,
)
plt.plot(
    vehicles,
    operational_costs,
    "^-",
    color="purple",
    label=label_Operational_Costs,
    markersize=8,
    linewidth=2,
)

# Customize the x and y axes limits and labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.xticks(vehicles, labels=[str(v) for v in vehicles])  # Ensuring x-ticks match the vehicle numbers
plt.xlim(
    left=vehicles[0] * 0.9, right=vehicles[-1] * 1.1
)  # Set x-axis limits to prevent cutting off data points
plt.ylim(
    bottom=0, top=max(fuel_efficiency.max(), maintenance_cost.max(), carbon_emissions.max(), operational_costs.max()) * 1.1
)  # Extend y-axis to leave some space above and below the data

# Adjust the legend position
plt.legend(bbox_to_anchor=(1, 0.5), fontsize=12, frameon=True)

# Add grid lines for better readability
plt.grid(True, which="both", ls="--", color="grey", linewidth=1, alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig('line_44.pdf', bbox_inches='tight')
