import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0)

np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data preparation
# Data
times = [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0]
gdp_growth = [10, 25, 40, 55, 20, 60, 45, 35, 25, 15, 10]
market_decay = [50, 40, 30, 20, 15, 10, 25, 35, 20, 10, 15]
stock_oscillation = [0, 20, 40, 0, -20, -40, -10, 30, 50, 20, -30]

# Extracted variables
gdp_growth_label = "GDP Growth"
market_decay_label = "Market Decay"
stock_oscillation_label = "Stock Oscillation"

xlim_values = (0, 10)
ylim_values_growth = (0, 80)
ylim_values_decay = (0, 60)
ylim_values_oscillation = (-50, 60)

yticks_growth = [0, 20, 40, 60, 80]
yticks_decay = [0, 10, 20, 30, 40, 50]
yticks_oscillation = [-50, -25, 0, 25, 50]

xlabel_value = "Time (years)"
ylabel_value_growth = "GDP Growth (%)"
ylabel_value_decay = "Market Value"
ylabel_value_oscillation = "Stock Value Change"

title_growth = "GDP Growth Over Time"
title_decay = "Market Decay Over Time"
title_oscillation = "Stock Market Oscillation Over Time"


legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_frameon = False

grid_linestyle = "--"
grid_alpha = 0.5

tick_params_color = "gray"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(6, 9))

# First subplot: Growth
axs[0].plot(
    times,
    gdp_growth,
    label=market_decay_label,
    color="green",
    clip_on=False,
    zorder=10,
    linestyle="-",
    marker="o",
)
axs[0].set_title(title_growth, y=1.1)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_growth)
axs[0].set_yticks(yticks_growth)
axs[0].set_ylabel(ylabel_value_growth)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[0].tick_params(axis="both", which="both", color=tick_params_color)

# Second subplot: Decay
axs[1].plot(
    times,
    market_decay,
    label=market_decay_label,
    color="red",
    clip_on=False,
    zorder=10,
    linestyle="-",
    marker="x",
)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_decay)
axs[1].set_yticks(yticks_decay)
axs[1].set_title(title_decay, y=1.1)
axs[1].set_ylabel(ylabel_value_decay)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[1].tick_params(axis="both", which="both", color=tick_params_color)

# Third subplot: Oscillation
axs[2].plot(
    times,
    stock_oscillation,
    label=stock_oscillation_label,
    clip_on=False,
    zorder=10,
    color="blue",
    linestyle="-",
    marker="s",
)
axs[2].set_title(title_oscillation, y=1.1)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_oscillation)
axs[2].set_yticks(yticks_oscillation)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_oscillation)
axs[2].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[2].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[2].tick_params(
    axis="both",
    which="both",
    color=tick_params_color,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_49.pdf", bbox_inches="tight")
