import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample data
vehicle_speed = [10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
fuel_efficiency_direct = [30, 28, 25, 23, 20, 18, 15, 13, 10, 8]
fuel_efficiency_scratchpad = [32, 29, 26, 24, 21, 19, 16, 14, 11, 9]
fuel_efficiency_rule_following = [33, 31, 27, 25, 22, 20, 17, 15, 12, 10]

# Labels and Plot Types
label_direct_method = "Direct Method"
label_scratchpad_method = "Scratchpad Method"
label_rule_following_method = "Rule-Following Method"

# Axes Limits and Labels
xlabel_value = "Vehicle Speed (km/h)"
ylabel_value = "Fuel Efficiency (mpg)"
xlim_values = [5, 105]
ylim_values = [5, 35]
xticks_values = range(10, 101, 10)
yticks_values = [i * 5 for i in range(2, 8)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(6, 4))  # Adjusting figure size as per the given dimensions
plt.plot(vehicle_speed, fuel_efficiency_direct, "o--", label=label_direct_method, color="#1f77b4")
plt.plot(
    vehicle_speed, fuel_efficiency_scratchpad, "o--", label=label_scratchpad_method, color="#ff7f0e"
)
plt.plot(
    vehicle_speed,
    fuel_efficiency_rule_following,
    "o--",
    label=label_rule_following_method,
    color="#2ca02c",
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adjusting x and y axis limits to add some space before the start and after the end
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Setting x and y ticks
plt.xticks(xticks_values)  # X-axis from 10 to 100 with a step of 10
plt.yticks(yticks_values)  # Y-axis from 10 to 35 with a step of 5

# Adding legend outside the plot area
plt.legend(loc="upper right", fancybox=True, shadow=False)

# Adding semi-transparent grid
plt.grid(True, which="both", linewidth=0.5, alpha=0.2)  # Semi-transparent grid

# Removing top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig('line_5.pdf', bbox_inches='tight')
