import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Generate different datasets for each subplot
x = np.linspace(0, 20, 20)

# Generate original data with some noise
data_1 = np.sin(x) + np.array([0.18, 0.91, 0.96, 0.21, -0.69, -0.95, 0.13, 0.87, 0.83, -0.01, -0.88, -0.69, 0.14, 0.91, 0.87, -0.05, -0.76, -0.84, 0.13, 0.83])  # Original data with noise
data_2 = np.cos(x) + np.array([0.74, 0.56, -0.42, -1.07, -0.25, 0.38, 1.0, 0.45, -0.38, -0.85, -0.44, 0.59, 0.91, 0.24, -0.6, -0.98, -0.3, 0.7, 0.96, 0.38])  # Different data with noise
data_3 = np.tan(x) + np.array([0.74, 0.56, -0.42, -1.07, -0.25, 0.38, 1.0, 0.45, -0.38, -0.85, -0.44, 0.59, 0.91, 0.24, -0.6, -0.98, -0.3, 0.7, 0.96, 0.38])  # Another dataset with noise

# Compute smoothed data using convolution with a moving average filter
smoothed_data = np.convolve(data_1, np.ones(5) / 5, mode="valid")

# Compute the difference of the second dataset
difference_data = np.diff(data_2)

# Compute the cumulative sum of the third dataset
cumulative_data = np.cumsum(data_3)

# Axes Limits and Labels
xlabel_value = "Time"
ylabel_value_1 = "Value"
ylabel_value_2 = "Delta Value"
ylabel_value_3 = "Cumulative Value"

# Labels for the plots
label_1 = "Smoothed Data"
label_2 = "Difference Data"
label_3 = "Cumulative Sum"

# Titles for the subplots
title_1 = "Smoothed Representation"
title_2 = "First Difference of Data"
title_3 = "Cumulative Sum Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(5, 10))

# First subplot: Smoothed Data
axs[0].plot(
    x[2:-2],  # Adjusting x to match the valid mode of the convolution
    smoothed_data,
    label=label_1,
    color="purple",
    linestyle="-",
    marker="o",
)
axs[0].set_title(title_1)
axs[0].set_ylabel(ylabel_value_1)
axs[0].legend(loc="upper right")
axs[0].grid(True, linestyle="--", alpha=0.5)

# Second subplot: Difference Data
axs[1].plot(
    x[1:],  # Adjusting x to match the length of the difference data
    difference_data,
    label=label_2,
    color="orange",
    linestyle="-",
    marker="x",
)
axs[1].set_title(title_2)
axs[1].set_ylabel(ylabel_value_2)
axs[1].legend(loc="upper right")
axs[1].grid(True, linestyle="--", alpha=0.5)

# Third subplot: Cumulative Sum
axs[2].plot(
    x,
    cumulative_data,
    label=label_3,
    color="green",
    linestyle="-",
    marker="s",
)
axs[2].set_title(title_3)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_3)
axs[2].legend(loc="upper right")
axs[2].grid(True, linestyle="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig('line_50.pdf', bbox_inches='tight')
