
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Time in years
t = [2000, 2002, 2004, 2006, 2008, 2010, 2012, 2014, 2016,]

# Data representing different technology trends with varied growth speeds
internet_usage = [5.8, 18.0, 65.0, 72.0, 73.5, 72.5, 69.0, 65.0, 61.0]  # in percentage, rise then fall
mobile_device_adoption = [1.2, 10.0, 35.0, 65.0, 80.0, 92.0, 92.5, 92.8, 93.0]  # in percentage, rapid then steady rise
software_development_jobs = [0.35, 0.55, 1.10,  2.02, 2.03, 2.00, 1.90, 1.80, 1.70]  # in millions, rapid rise then fall
tech_investment_growth = [50, 100, 210, 360, 520, 620, 670, 690, 720]  # in billions USD, rapid then slow rise
# Labels for legend
label_internet_usage = "Internet Usage"
label_mobile_device_adoption = "Mobile Device Adoption"
label_software_development_jobs = "Software Development Jobs"
label_tech_investment_growth = "Tech Investment Growth"

# Plot configuration
xlim_values = (2000, 2016)
ylim_values_usage_adoption = (0, 100)
ylim_values_jobs = (0, 2.5)
ylim_values_investment = (0, 2000)

xlabel_value = "Year"
ylabel_value_usage = "Percentage (%)"
ylabel_value_adoption = "Percentage (%)"
ylabel_value_jobs = "Number of Jobs (Millions)"
ylabel_value_investment = "Investment (Billion USD)"

title_internet_usage = "Growth in Internet Usage"
title_mobile_device_adoption = "Rise of Mobile Device Adoption"
title_software_development_jobs = "Increase in Software Development Jobs"
title_tech_investment_growth = "Growth of Tech Investments"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(4, 1, figsize=(6, 12))

axs[0].plot(t, internet_usage, label=label_internet_usage, color="magenta")
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_usage_adoption)
axs[0].set_title(title_internet_usage, y=1.1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_usage)

axs[1].plot(t, mobile_device_adoption, label=label_mobile_device_adoption, color="green")
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_usage_adoption)
axs[1].set_title(title_mobile_device_adoption, y=1.1)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_adoption)

axs[2].plot(t, software_development_jobs, label=label_software_development_jobs, color="blue")
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_jobs)
axs[2].set_title(title_software_development_jobs, y=1.1)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_jobs)

axs[3].plot(t, tech_investment_growth, label=label_tech_investment_growth, color="red")
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_investment)
axs[3].set_title(title_tech_investment_growth, y=1.1)
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_investment)

for ax in axs.flat:
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('line_51.pdf', bbox_inches='tight')
