import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for four different scenarios
# Scenario 1: Sensor readings over time
time1 = np.array([1, 2, 3, 4, 5])
sensor_readings = np.array([20, 21, 19, 22, 20])
sensor_errors = np.array([1, 0.5, 1.5, 1, 0.8])

# Scenario 2: Temperature measurements at different altitudes
altitudes = np.array([100, 200, 300, 400])
temperatures = np.array([15, 14, 13, 12])
temp_errors = np.array([0.5, 0.3, 0.4, 0.6])

# Scenario 3: Sales over different months
months = np.array([1, 2, 3, 4, 5, 6])
sales = np.array([150, 160, 155, 165, 170, 175])
sales_errors = np.array([10, 5, 7, 6, 8, 9])

# Scenario 4: Growth of a plant over days
days = np.array([1, 3, 5, 7, 9])
plant_growth = np.array([2, 2.5, 3, 3.5, 4])
growth_errors = np.array([0.2, 0.3, 0.25, 0.3, 0.2])

# Titles for each subplot
titles = [
    "Sensor Readings Over Time",
    "Temperature Measurements at Different Altitudes",
    "Sales Over Six Months",
    "Plant Growth Over Days",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x2 subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Flatten the axis array for easy iteration
axs = axs.flatten()

# Setting data for each subplot
data = [
    (time1, sensor_readings, sensor_errors),
    (altitudes, temperatures, temp_errors),
    (months, sales, sales_errors),
    (days, plant_growth, growth_errors),
]

# Plot with error bars in each subplot
for ax, (x, y, e), title in zip(axs, data, titles):
    ax.errorbar(
        x, y, yerr=e, fmt="-o", color="blue", ecolor="red", capsize=5, markersize=6
    )
    ax.set_title(title, fontsize=14)
    ax.grid(True, alpha=0.5)
    ax.set_xticks(x)
    ax.set_yticks(np.linspace(min(y) - max(e), max(y) + max(e), num=5, endpoint=True))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('line_52.pdf', bbox_inches='tight')
