import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(42)


# ===================
# Part 2: Data Preparation
# ===================
# Enhanced sample data to accommodate more subplots
x1 = np.array([2015, 2016, 2017, 2018, 2019])
y1 = np.array([1043.64, 1187.68, 1133.0, 1099.66, 989.0])  # Vehicle Miles Traveled (in billions)
e1 = np.array([24.68, 21.74, 45.99, 38.03, 41.24])

x2 = np.array([2015, 2016, 2017, 2018])
y2 = np.array([229.96, 276.06, 258.56, 247.89])  # Public Transport Ridership (in millions)
e2 = np.array([18.12, 18.12, 16.16, 32.32])

x3 = np.array([2010, 2012, 2014, 2016, 2018, 2020])
y3 = np.array([15.62, 24.26, 20.98, 18.98, 12.34, 12.34])  # Electric Vehicle Adoption Rate (in %)
e3 = np.array([0.34, 0.91, 0.72, 0.8, 0.31, 0.98])

x4 = np.array([5, 10, 15, 20, 25])
y4 = np.array([35.62, 44.26, 40.98, 38.98, 32.34])  # Average Commute Time (in minutes)
e4 = np.array([1.47, 1.17, 3.6, 2.8, 3.12])

x5 = np.array([1, 2, 3, 4, 5])
y5 = np.array([74.98, 98.03, 89.28, 83.95, 66.24])  # Number of Traffic Accidents (in thousands)
e5 = np.array([3.78, 3.29, 7.33, 6.01, 6.54])

x6 = np.array([200, 400, 600, 800, 1000])
y6 = np.array([187.45, 245.07, 223.2, 209.87, 165.6])  # Bicycle Lane Miles (in miles)
e6 = np.array([6.56, 5.58, 13.66, 11.01, 12.08])

# Titles
titles = [
    "Vehicle Miles Traveled",
    "Public Transport Ridership",
    "Electric Vehicle Adoption",
    "Average Commute Time",
    "Traffic Accidents",
    "Bicycle Lane Miles",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x3 subplots for a unified visual presentation
fig, axs = plt.subplots(2, 3, figsize=(12, 8))

colors = ["red", "green", "blue", "purple", "magenta", "cyan"]

data_pairs = [
    (x1, y1, e1),
    (x2, y2, e2),
    (x3, y3, e3),
    (x4, y4, e4),
    (x5, y5, e5),
    (x6, y6, e6),
]

for ax, (x, y, e), title, color in zip(axs.flat, data_pairs, titles, colors):
    ax.errorbar(
        x, y, yerr=e, fmt="-o", color=color, ecolor="lightgray", capsize=5, label=title
    )
    ax.set_title(title)
    ax.set_xticks(x)
    ax.set_ylim(min(y) - min(e) - 10, max(y) + max(e) + 10)
    ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()
plt.savefig('line_53.pdf', bbox_inches='tight')
