import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
modes_of_transport = ["Car", "Bus", "Bicycle", "Train"]
fuel_efficiency_city = [25, 8, 2, 50]  # MPG for city conditions
fuel_efficiency_highway = [35, 12, 2, 67]  # MPG for highway conditions
fuel_efficiency_rural = [30, 10, 3, 60]  # MPG for rural conditions
fuel_efficiency_urban = [22, 7, 3, 45]  # MPG for urban conditions
error = [2, 1, 0.5, 3]  # Error margins

# Axes Limits and Labels
xlabel_value = "Mode of Transport"
ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [0, 90]

# Titles
titles = ["City vs Highway", "Rural vs Urban", "Highway vs Rural"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x3 subplot layout
fig, axs = plt.subplots(1, 3, figsize=(12, 4))

# Titles and setup for subplots
data_pairs = [
    (fuel_efficiency_city, fuel_efficiency_highway),
    (fuel_efficiency_rural, fuel_efficiency_urban),
    (fuel_efficiency_highway, fuel_efficiency_rural),
]
colors_pairs = [("black", "red"), ("blue", "green"), ("red", "blue")]

# Plot each condition in a separate subplot
for ax, title, (data1, data2), (color1, color2) in zip(axs, titles, data_pairs, colors_pairs):
    ax.errorbar(
        modes_of_transport,
        data1,
        yerr=error,
        fmt="o-",
        color=color1,
        ecolor=color1,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[0]}',
    )
    ax.errorbar(
        modes_of_transport,
        data2,
        yerr=error,
        fmt="s-",
        color=color2,
        ecolor=color2,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[1]}',
    )
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.tick_params(
        axis="both", which="major", length=5, direction="in", top=True, right=True
    )
    ax.legend(loc="upper right", frameon=True)
    ax.set_ylim(ylim_values)
    ax.grid(True, which="major", linestyle="--", linewidth=0.5, alpha=0.5)
    ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('line_54.pdf', bbox_inches='tight')
