import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Updated data for transportation metrics
n_aug = ["0", "0.125", "0.25", "0.5", "1", "2", "4", "8"]
fuel_efficiency = np.array([15, 18, 22, 28, 35, 23, 13, 15])  # Dynamic changes
safety_rating = np.array([13, 13.5, 14, 15.5, 4.8, 4.6, 14.3, 4])  # Smooth increase then slight decrease
comfort_level = np.array([12, 13, 14, 5, 14, 15, 4, 13])  # Peak in the middle

# Axes Limits and Labels
xlabel_value = "Technology Augmentation Level (n$_{aug}$)"
xlim_values = [0, len(n_aug) - 1]

ylabel_value = "Performance Gain (%)"
ylim_values = [0, max(fuel_efficiency) + 5]

# Labels
label_fuel_efficiency = "Fuel Efficiency"
label_safety_rating = "Safety Rating"
label_comfort_level = "Comfort Level"

# Titles
title = "Performance Gain Across Different Levels of Technological Augmentation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 3))
ax.plot(
    n_aug, fuel_efficiency, "o-", label=label_fuel_efficiency, color="royalblue", linewidth=2, markersize=8
)
ax.plot(
    n_aug,
    safety_rating,
    "s--",
    label=label_safety_rating,
    color="crimson",
    linewidth=2,
    markersize=8,
)
ax.plot(
    n_aug,
    comfort_level,
    "^:",
    label=label_comfort_level,
    color="limegreen",
    linewidth=2,
    markersize=8,
)

# Enhancements for visual appeal
ax.set_facecolor("#e6f0ff")  # Light blue background
ax.spines["top"].set_color("none")
ax.spines["right"].set_color("none")
ax.spines["left"].set_color("gray")
ax.spines["bottom"].set_color("gray")

# Setting axis limits and ticks dynamically based on data
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Customizing labels and grid
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Custom legend
ax.legend(loc="upper right", fontsize=12, frameon=True, shadow=True)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, color="grey")

# ===================
# Part 4: Saving Output
# ===================
# Tight layout for better spacing
plt.tight_layout()
plt.savefig('line_55.pdf', bbox_inches='tight')
