import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
iterations = np.linspace(0, 200, 50)
base_fuel_efficiency = np.array([32.65, 31.02, 32.32, 34.72, 34.59, 30.48, 33.99, 32.61, 33.09, 34.36, 34.33, 37.0, 36.23, 35.52, 36.51, 36.73, 39.26, 36.56, 37.93, 36.14, 33.29, 39.83, 40.66, 37.93, 44.31, 37.28, 40.71, 40.64, 44.6, 44.91, 42.57, 43.46, 41.15, 39.16, 43.11, 44.63, 47.44, 47.81, 44.63, 45.22, 43.9, 43.42, 43.12, 52.19, 46.74, 47.31, 45.72, 51.1, 45.59, 49.47])
optimized_fuel_efficiency = np.array([33.43, 36.09, 34.9, 34.09, 36.58, 37.83, 37.57, 38.43, 37.05, 37.97, 37.77, 38.78, 38.28, 36.83, 41.08, 40.3, 38.15, 42.91, 40.43, 42.87, 44.74, 43.85, 46.49, 41.65, 45.7, 43.66, 43.63, 44.69, 45.71, 46.97, 44.49, 49.8, 49.18, 44.75, 52.51, 53.96, 52.62, 49.65, 47.81, 53.6, 50.29, 54.9, 52.69, 55.12, 53.9, 55.25, 53.8, 59.02, 54.94, 56.11])

# Axes Limits and Labels
xlabel_value = "Training Iterations"
ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [25, 60]

# Labels
label_Base_Model = "Base Model"
label_Optimized_Model = "Optimized Model"

# Titles
title = "Fuel Efficiency Improvement Over Training Iterations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customization options
color_base = "deepskyblue"
marker_base = "o"
style_base = "-"

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(
    iterations,
    base_fuel_efficiency,
    label=label_Base_Model,
    color=color_base,
    marker=marker_base,
    markersize=5,
    linestyle=style_base,
    linewidth=2,
)
ax.plot(
    iterations,
    optimized_fuel_efficiency,
    label=label_Optimized_Model,
    color=color_base,
    marker=marker_base,
    markersize=5,
    linestyle=style_base,
    linewidth=2,
)

# Enhance the plot with a title, labels, and legend
ax.set_title(title)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# Add a legend to the plot
ax.set_ylim(ylim_values)
ax.legend(loc="upper right", frameon=True, shadow=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig('line_59.pdf', bbox_inches='tight')
