import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
electric_vehicles = np.array([120, 100, 80, 60, 40, 20])
gasoline_vehicles = np.array([200, 190, 180, 170, 160, 150])

# Axes Limits and Labels
xlabel_value = "Production Year"

ylim_values = [10, 210]
yticks_values = [50, 100, 150, 200]
yticks_labels = ["50", "100", "150", "200"]

# Labels
label_EV = "Electric Vehicles"
label_Gasoline = "Gasoline Vehicles"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(9, 6))

# Plot the data
plt.plot(
    years,
    electric_vehicles,
    "o-",
    color="#1f77b4",
    label=label_EV,
    markerfacecolor="#1f77b4",
    markersize=6,
)  # Solid dots for Electric Vehicles
plt.plot(years, gasoline_vehicles, "x-", color="#ff7f0e", label=label_Gasoline, markersize=6)

# Add labels with increased font size
plt.xlabel(xlabel_value, fontsize=14)

# Set y-axis to only display specific ticks
plt.yticks(
    yticks_values,
    yticks_labels,
)
plt.ylim(ylim_values)  # Set y-axis limits

# Explicitly set the tick params for the x-axis
plt.tick_params(axis="x", labelsize=14)  # Ensure x-axis tick labels are of font size 14

# Add legend with transparent background
plt.legend(frameon=True, fontsize=16)

# Add a vertical line at x=2010 and enable horizontal grid lines for structure
plt.axvline(x=2010, color="grey", linestyle="--", linewidth=1)
plt.grid(
    True, which="both", ls="--", color="grey", linewidth=1, axis="y"
)  # Horizontal grid lines

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig('line_6.pdf', bbox_inches='tight')
