import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
weeks = np.arange(1, 29)
fuel_efficiency_data = np.array([32.88, 32.57, 34.1, 36.15, 36.37, 33.9, 35.95, 34.72, 34.4, 34.32, 33.26, 33.62, 31.87, 30.12, 29.33, 28.16, 28.38, 25.89, 25.81, 24.27, 22.45, 25.78, 26.36, 25.35, 29.15, 26.38, 28.93, 29.81])
emission_level_data = np.array([139.32, 133.98, 139.26, 148.73, 150.66, 140.66, 154.75, 153.69, 158.16, 164.52, 166.36, 175.29, 173.3, 170.61, 171.72, 169.69, 173.11, 161.44, 160.24, 150.18, 137.24, 148.82, 145.64, 133.82, 145.71, 124.71, 130.73, 129.06])

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value_1 = "Fuel Efficiency (MPG)"
ylabel_value_2 = "Emission Level (g CO2/mile)"
ylim_values_fuel = [20, 40]
ylim_values_emission = [100, 200]

# Labels
label_fuel_efficiency = "Fuel Efficiency"
label_emission_level = "Emission Level"

# Titles
title = "Fuel Efficiency and Emission Levels Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# Plot the data on the primary y-axis
color_fuel = "tab:blue"
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color_fuel)
ax1.plot(
    weeks, fuel_efficiency_data, label=label_fuel_efficiency, color=color_fuel, marker="o", linestyle="-"
)
ax1.tick_params(axis="y", labelcolor=color_fuel)
ax1.set_ylim(ylim_values_fuel)

# Create a secondary y-axis and plot the data
ax2 = ax1.twinx()
color_emission = "tab:red"
ax2.set_ylabel(ylabel_value_2, color=color_emission)
ax2.plot(
    weeks, emission_level_data, label=label_emission_level, color=color_emission, marker="x", linestyle="--"
)
ax2.tick_params(axis="y", labelcolor=color_emission)
ax2.set_ylim(ylim_values_emission)

# Add a legend to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Customize the plot with a title, grid, and background color
ax1.set_facecolor("whitesmoke")
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Set the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig('line_60.pdf', bbox_inches='tight')
