import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
weeks = np.arange(1, 29)
fuel_efficiency = np.array([32.26, 31.39, 32.46, 34.19, 34.26, 31.85, 34.17, 33.44, 33.81, 34.62, 34.6, 36.11, 35.58, 35.05, 35.43, 35.33, 36.45, 34.66, 35.04, 33.69, 31.76, 34.7, 34.59, 32.64, 35.26, 31.12, 32.18, 31.49])
emission_levels = np.array([138.92, 132.4, 135.79, 142.78, 141.79, 128.61, 139.45, 135.31, 137.05, 141.25, 141.65, 150.02, 148.46, 147.21, 150.8, 152.25, 160.05, 153.52, 158.03, 154.05, 147.33, 165.04, 167.65, 161.04, 177.37, 159.87, 168.31, 167.91])
maintenance_costs = np.array([225.11, 218.78, 231.54, 250.64, 252.76, 229.39, 252.87, 245.09, 247.75, 253.98, 251.28, 263.24, 254.06, 244.38, 243.34, 237.11, 242.82, 219.32, 217.5, 198.52, 174.05, 198.65, 193.47, 170.45, 194.12, 151.07, 161.03, 154.55])

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Normalized Value"

# Labels
label_fuel_efficiency = "Fuel Efficiency"
label_maintenance_costs = "Maintenance Costs"
label_legend = ["Fuel Efficiency", "Emission Levels with Gradient", "Maintenance Costs"]

# Titles
title = "Transportation Metrics Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 8))

# Plot the fuel efficiency data
ax.plot(weeks, fuel_efficiency, label=label_fuel_efficiency, color="deepskyblue", linewidth=3)

# Plot the emission levels data with a gradient color
for i in range(len(weeks) - 1):
    ax.plot(
        weeks[i : i + 2],
        emission_levels[i : i + 2],
        linestyle="-",
        linewidth=3,
        color=plt.cm.viridis(i / len(weeks)),
    )

# Plot the maintenance costs data
ax.plot(
    weeks, maintenance_costs, label=label_maintenance_costs, color="magenta", linestyle="--", linewidth=3
)

# Customize the plot with labels, title, and legend
ax.set_title(title, fontsize=18)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Add a legend to the plot
custom_lines = [
    plt.Line2D([0], [0], color="deepskyblue", lw=4),
    plt.Line2D([0], [0], color="green", lw=4),
    plt.Line2D([0], [0], color="magenta", lw=4, linestyle="--"),
]
ax.legend(
    custom_lines,
    label_legend,
    fontsize=12,
)

# Add a grid to the plot
ax.set_facecolor("floralwhite")
ax.grid(True, which="both", linestyle=":", linewidth=0.75, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig('line_63.pdf', bbox_inches='tight')
