
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
# Sample data to mimic the trends in the provided image
# Tasks in a business performance tracking period
tasks = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]

# Data representing different business trends with varied patterns
sales_growth = [95.29, 90.87, 85.27, 80.72, 75.27, 70.4, 65.85, 61.21, 57.02, 53.23]  # steady decline
customer_retention = [55.43, 58.59, 60.73, 62.03, 64.22, 66.11, 67.82, 69.94, 70.72, 72.44]  # steady rise
market_share = [45.34, 47.74, 50.15, 49.11, 52.92, 51.53, 54.8, 53.88, 56.82, 55.41]  # fluctuating
employee_satisfaction = [60.15, 55.82, 50.00, 45.35, 40.43, 35.38, 30.9, 28.31, 25.17, 22.7]  # steady decline

# Labels and plot types
line_label_sales_growth = "Sales Growth"
line_label_customer_retention = "Customer Retention"
line_label_market_share = "Market Share"
line_label_employee_satisfaction = "Employee Satisfaction"

# Plot configuration
xlim_values = [1, 10]
ylim_values = [0, 100]
xlabel_value = "Task"
ylabel_value = "Average Value (%)"
xticks_values = np.arange(1, 11, 1)
yticks_values = np.arange(0, 101, 10)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 6))
plt.plot(
    tasks,
    sales_growth,
    marker="s",
    markersize=10,
    color="#2171b5",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_sales_growth,
    linewidth=2.5,
    linestyle="--",
)
plt.plot(
    tasks,
    customer_retention,
    marker="v",
    markersize=10,
    color="#6baed6",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_customer_retention,
    linewidth=2.5,
    linestyle="-.",
)
plt.plot(
    tasks,
    market_share,
    marker="D",
    markersize=10,
    color="#42cc46",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_market_share,
    linewidth=2.5,
    linestyle=":",
)
plt.plot(
    tasks,
    employee_satisfaction,
    marker="o",
    markersize=10,
    color="#9dfa9f",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_employee_satisfaction,
    linewidth=2.5,
)

# Customize the plot with labels, title, and legend
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Customize the x-axis ticks
plt.xticks(xticks_values)  # Ticks from 1 to 20, interval of 1
plt.xlim(xlim_values)  # Slightly beyond 1 and 20 for a margin

# Add a grid to the plot
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.tick_params(axis="x", which="both", length=0)
# Add a title to the plot
plt.legend(
    frameon=False,
    fontsize=12,
    loc="upper right",
    borderpad=1,
    ncol=4,
    bbox_to_anchor=(1, 1.1),
)

# Add a grid to the plot
plt.grid(True, linestyle="-", linewidth=0.5, axis="y")

# Set the background color of the plot
ax = plt.gca()
ax.set_facecolor(
    mcolors.LinearSegmentedColormap.from_list("custom", ["#e6f7ff", "#ffffff"])(0.8)
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig('line_64.pdf', bbox_inches='tight')
