# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
years = np.array([2015, 2016, 2017, 2018, 2019, 2020, 2021])
graduation_rates = np.clip(
    np.linspace(75, 85, len(years)) + np.random.normal(0, 1.5, len(years)),
    70,
    90,
)
dropout_rates = np.clip(
    np.linspace(10, 5, len(years)) + np.random.normal(0, 1, len(years)),
    3,
    12,
)
teacher_student_ratio = [15] * len(years)  # constant teacher-student ratio
average_class_size = [25] * len(years)  # constant average class size

labels = ["Graduation Rate", "Dropout Rate"]
xlabel = "Year"
ylabels = ["Graduation Rate (%)", "Dropout Rate (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(6, 5))

# Graduation and dropout rates plots
(graduation_line,) = ax1.plot(
    years,
    graduation_rates,
    "o-",
    color="#377eb8",
    label=labels[0],
    markersize=10,
    linewidth=3,
    mec="black",
)
ax1.set_xlabel(xlabel, fontsize=14)
ax1.set_ylabel(ylabels[0], fontsize=14, color="#377eb8")
ax1.tick_params(
    axis="y", labelcolor="#377eb8", direction="in", rotation=90, labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(range(70, 95, 5))
ax1.set_ylim(70, 90)

ax2 = ax1.twinx()
(dropout_line,) = ax2.plot(
    years,
    dropout_rates,
    "^-",
    color="#ff7f00",
    label=labels[1],
    markersize=10,
    linewidth=3,
    mec="black",
)
ax2.set_ylabel(ylabels[1], color="#ff7f00", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#ff7f00", direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(range(3, 15, 3))
ax2.set_ylim(3, 15)

# Teacher-student ratio and average class size
ax1.axhline(y=15, color="#377eb8", linestyle=":", linewidth=2)
ax1.axhline(y=25, color="#ff7f00", linestyle="--", linewidth=2)

# Custom legend for the plot
ratio_legend = Line2D([0], [0], color="black", linestyle=":", linewidth=2, label="TS Ratio")
class_size_legend = Line2D([0], [0], color="black", linestyle="--", linewidth=2, label="Avg Class Size")

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[ratio_legend, class_size_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)

# ===================
# Part 4: Saving Output
# ===================
# Add the second legend to the plot
plt.tight_layout()
plt.savefig('line_67.pdf', bbox_inches='tight')
