import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
epochs = np.array([10, 20, 30, 40, 50, 60, 70])
cnn_accuracy = np.clip(
    np.linspace(60, 90, len(epochs)) + np.random.normal(0, 1, len(epochs)),
    60,
    90,
)
rnn_accuracy = np.clip(
    np.linspace(50, 85, len(epochs)) + np.random.normal(0, 1.5, len(epochs)),
    50,
    85,
)
cnn_loss = [0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2]  # Decreasing CNN loss rates
rnn_loss = [1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4]  # Decreasing RNN loss rates

# Axes Limits and Labels
xlabel_value = "Epochs"

ylabel_value_1 = "Accuracy (%)"
ylabel_value_2 = "Loss"
ylim_values_1 = [50, 100]
ylim_values_2 = [0, 1.2]
yticks_values_1 = np.arange(50, 101, 10)
yticks_values_2 = np.arange(0, 1.3, 0.2)

# Labels
label_1 = "CNN Accuracy"
label_2 = "RNN Accuracy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(8, 7))

# CNN and RNN Accuracy plots
(cnn_line,) = ax1.plot(
    epochs,
    cnn_accuracy,
    color="#377eb8",
    label=label_1,
    markersize=10,
    linewidth=3,
    mec="black",
    linestyle="-.",
    marker="o",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#377eb8")
ax1.tick_params(
    axis="y", labelcolor="#377eb8", direction="in", rotation=90, labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

# Create a secondary y-axis for RNN Accuracy
ax2 = ax1.twinx()
(rnn_line,) = ax2.plot(
    epochs,
    rnn_accuracy,
    color="#ff7f00",
    label=label_2,
    markersize=10,
    linewidth=3,
    mec="black",
    linestyle=":",
    marker="^",
)
ax2.set_ylabel(ylabel_value_2, color="#ff7f00", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#ff7f00", direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# CNN and RNN Loss rates
ax1.plot(epochs, cnn_loss, ":", color="green", linewidth=2, label="CNN Loss")
ax1.plot(epochs, rnn_loss, "--", color="purple", linewidth=2, label="RNN Loss")

# Custom legend for the plot
cnn_legend = Line2D(
    [0], [0], color="green", linestyle=":", linewidth=2, label="CNN Loss"
)
rnn_legend = Line2D(
    [0], [0], color="purple", linestyle="--", linewidth=2, label="RNN Loss"
)

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[cnn_legend, rnn_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)  # Add the first legend back to the plot
second_legend = ax1.legend(
    handles=[cnn_line, rnn_line], loc="upper right", fontsize=14, edgecolor="black"
)  # Add the second legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig('line_68.pdf', bbox_inches='tight')

