import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
driving_styles = ["Eco", "Normal", "Sport", "Aggressive"]
fuel_consumption_normal = [4.5, 6.0, 7.5, 10.0]
fuel_consumption_aggressive = [6.0, 8.0, 10.5, 13.5]
error = [0.3, 0.4, 0.5, 0.6]

# Axes Limits and Labels
xlabel_value = "Driving Style"

ylabel_value = "Fuel Consumption (L/100 km)"
ylim_values = [0, 15]

# Labels
label_Normal = "Normal"
label_Aggressive = "Aggressive"

# Titles
title = "Driving Conditions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(6, 6))
ax.errorbar(
    driving_styles,
    fuel_consumption_normal,
    yerr=error,
    fmt="o-",
    color="black",
    ecolor="black",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Normal,
)
ax.errorbar(
    driving_styles,
    fuel_consumption_aggressive,
    yerr=error,
    fmt="s-",
    color="red",
    ecolor="red",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Aggressive,
)

# Customization
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

ax.tick_params(
    axis="both", which="major", length=5, direction="in", top=True, right=True
)
ax.legend(title=title, loc="lower left", frameon=False)
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('line_8.pdf', bbox_inches='tight')
