import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from matplotlib.ticker import FuncFormatter, FixedLocator

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
years = np.array([2010, 2012, 2014, 2016, 2018])
electric_vehicles = np.array([100, 80, 60, 50, 30])
gasoline_vehicles = np.array([200, 190, 180, 170, 160])

# Axes Limits and Labels
xlabel_value = "Year"

yticks_values = [50, 100, 150, 200, 250]
yticks_labels = [
        "$50$",
        "$100$",
        "$150$",
        "$200$",
        "$250$",
    ]
ylim_values = [20, 220]

axvline_x = 2016
        
# Labels
label_Electric = "Electric Vehicles"
label_Gasoline = "Gasoline Vehicles"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(9, 6))
plt.plot(
    years, electric_vehicles, "o-", label=label_Electric, color="#1f77b4", linewidth=1.4, markersize=4
)
plt.plot(
    years,
    gasoline_vehicles,
    "x-",
    label=label_Gasoline,
    color="#ff7f0e",
    markersize=6,
    markeredgewidth=1,
)

# Setting the x-axis and y-axis to log scale
plt.xscale("linear")
plt.yscale("linear")

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(
    yticks_values,
    yticks_labels,
)
plt.ylim(ylim_values)  # Extend y-axis to leave some space above 10^-1

# Disable the automatic grid for x-axis
plt.grid(True, which="both", ls="--", axis="y")  # Only enable y-axis grid

# Manually add a grid line for x=2016
plt.axvline(x=axvline_x, color="grey", linestyle="--", linewidth=0.5)

# Formatting the x-axis and y-axis tick labels
plt.gca().xaxis.set_major_formatter(FuncFormatter(lambda value, _: "{:.0f}".format(value)))
plt.gca().yaxis.set_major_formatter(FuncFormatter(lambda y, _: "{:.0f}".format(y)))

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=12)

# Adding a legend at the center right
plt.legend(loc="center right", fontsize=18)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig('line_9.pdf', bbox_inches='tight')
