import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Revenue sources for the pie chart
revenue_sources = [
    "Product Sales",
    "Service Fees",
    "Investments",
    "Other Income",
]
revenue_counts = [400, 300, 150, 150]

# Quarterly revenue and profit for the scatter plot
quarters = ["Q1", "Q2", "Q3", "Q4"]
years = [2020, 2017, 2016, 2022]
revenue = [200, 300, 350, 400]

# Axes Limits and Labels
title_1 = "Revenue Sources Breakdown"

title_2 = "Quarterly Revenue and Profit"
xlabel_value = "Year"
ylabel_value = "Amount (in $ thousands)"
ylim_values = [0, 450]
xlim_values = [2015, 2023]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and set up GridSpec
fig = plt.figure(figsize=(10, 5))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1])

# Create pie chart on the left
ax1 = fig.add_subplot(gs[0])
wedges, texts, autotexts = ax1.pie(
    revenue_counts,
    labels=revenue_sources,
    autopct="%1.1f%%",
    startangle=90,
    colors=["gold", "lightblue", "lightgreen", "salmon"],
)
ax1.set_title(title_1)

# Create scatter plot on the right
ax2 = fig.add_subplot(gs[1])
scatter = ax2.scatter(
    years,
    revenue,
    color="blue",
    s=np.array(revenue),
    alpha=0.5,
    edgecolor="black",
)
ax2.set_title(title_2)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.grid(True)
ax2.set_ylim(ylim_values)
ax2.set_xlim(xlim_values)

# Add text labels to scatter points
for i, txt in enumerate(quarters):
    ax2.annotate(txt, (years[i], revenue[i] + 20))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('multidiff_5.pdf', bbox_inches='tight')
