import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the charts
labels = ["Cars", "Buses", "Trains", "Bikes"]
traffic_data_2023 = [35.7, 24.9, 18.0, 21.4]
traffic_data_2024 = [32.5, 28.3, 22.4, 16.8]
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99"]
titles = ["Traffic Distribution 2023", "Traffic Distribution 2024"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(1, 2, figsize=(10, 4))

# Traffic Distribution 2023 Donut Chart
explode1 = (0.1, 0, 0, 0)
ax[0].pie(
    traffic_data_2023,
    labels=labels,
    colors=colors,
    startangle=90,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode1,
    autopct="%1.1f%%",
)
ax[0].set_title(titles[0])

# Traffic Distribution 2024 Donut Chart
explode2 = (0, 0.2, 0, 0)
ax[1].pie(
    traffic_data_2024,
    labels=labels,
    colors=colors,
    startangle=90,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode2,
    autopct="%1.1f%%",
)
ax[1].set_title(titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig('pie_12.pdf', bbox_inches='tight')
