# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
labels = ["Cardiology 30%", "Neurology 25%", "Oncology 20%", "Dermatology 25%"]
sizes = [30, 25, 20, 25]
title = "Specialty Distribution in a Medical Facility"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(7, 7))
hatches = ['/', '\\', '|', '-']
start_angle = 140
shadow = True
pct_distance = 0.85
center_circle_radius = 0.70
colors = ['#FF6347', '#4682B4', '#3CB371', '#FFA500']  # Tomato, Steel Blue, Medium Sea Green, Orange
ax.pie(sizes, labels=labels, colors=colors, autopct='%1.1f%%', startangle=start_angle, 
       hatch=hatches, shadow=shadow, pctdistance=pct_distance)
plt.title(title)

# Draw center circle for a donut effect
centre_circle = plt.Circle((0, 0), center_circle_radius, fc='white')
fig.gca().add_artist(centre_circle)

# Ensure that pie is drawn as a circle.
ax.axis('equal')  

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('pie_18.pdf', bbox_inches='tight')