# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================

import numpy as np

# Data for new pie chart
categories = ['Research', 'Development', 'Testing', 'Deployment', 'Maintenance']
percentages = [25, 30, 20, 15, 10]

# Extracted variables
title_text = "Software Project Phases Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 10))  # Adjust figure size for better visualization
title_fontsize = 22
legend_location = "best"
legend_bbox_to_anchor = (0, 0.8)
colors = plt.cm.Paired(np.linspace(0, 1, 5))  # Different colormap for visual diversity
explode = (0.05, 0.05, 0.05, 0.05, 0.05)  # Smaller explosion for subtler separation
patches, texts, autotexts = ax.pie(
    percentages,
    colors=colors,
    autopct="%1.1f%%",
    startangle=90,
    wedgeprops=dict(edgecolor="black"),
    explode=explode,
    pctdistance=0.75  # Adjust percentage labels position for better clarity
)

# Optional: creating a donut chart by adding a center circle
donut_circle = plt.Circle((0, 0), 0.60, fc='white')
fig.gca().add_artist(donut_circle)

# Ensure pie is drawn as a circle
ax.axis("equal")

plt.title(title_text, fontsize=title_fontsize)
plt.legend(patches, categories, loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot and save with an updated filename
plt.tight_layout()
plt.savefig('pie_19.pdf', bbox_inches='tight')