import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Different data for another example
labels = ["Cars 40%", "Bikes 25%", "Buses 20%", "Trains 15%"]
outer_sizes = [40, 25, 20, 15]  # usage of transportation modes
inner_sizes = [20, 30, 25, 35]  # usage of transportation modes for commuting

outer_colors = ["#ffcc99", "#66b3ff", "#99ff99", "#ffccff"]
inner_colors = ["#ff9999", "#66c2a5", "#8da0cb", "#e78ac3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=160,
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.8,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=160,
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('pie_2.pdf', bbox_inches='tight')
