import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
labels = ["Wheat 35%", "Corn 25%", "Rice 20%", "Soybeans 20%"]
sizes = [35, 25, 20, 20]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(5, 5))
ax.pie(sizes, labels=labels, hatch=['**O', 'oO', 'O.O', '.||.'])
plt.title("Major Crop Production")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('pie_4.pdf', bbox_inches='tight')
