# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np; np.random.seed(0)
# Define the vector field function for normal traffic flow
def normal_traffic_flow(X, Y):
    U_normal = -Y
    V_normal = X
    return U_normal, V_normal

def peak_traffic_flow(X, Y):
    U_peak = -1 - X**2 + Y
    V_peak = 1 + X - Y**2
    return U_peak, V_peak

# Create a grid of points representing intersections
x = np.linspace(0, 0.8, 10)
y = np.linspace(0, 0.8, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field for normal traffic flow
U_normal, V_normal = normal_traffic_flow(X, Y)

# Compute the vector field for peak traffic flow
U_peak, V_peak = peak_traffic_flow(X, Y)

# Plot the curves representing different travel paths
utilization_rate = np.linspace(0.2, 0.4, 100)  # Updated range for city block distances
xlabel = "Utilization Rate (%)"
ylabel = "Charging Sessions (per hour)"
patch_labels = ["Peak Hours", "Off-Peak Hours"]
line_labels = ["Station A", "Station B", "Station C", "Station D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))

# Quiver plots for traffic flow
plt.quiver(X, Y, U_normal, V_normal, color="orangered", alpha=0.6) # Normal Flow
plt.quiver(X, Y, U_peak, V_peak, color="skyblue", alpha=0.6) # Peak Flow

# Plot different travel paths/detours
plt.plot(utilization_rate, 0.09 / (utilization_rate**1.2), color="#33cc33", linestyle='-')
plt.plot(utilization_rate, 0.08 / (utilization_rate**1.2 + 0.04), color="#ffa500", linestyle='--')
plt.plot(utilization_rate, 0.075 / (utilization_rate**1 + 0.04), color="#999999", linestyle='-.')
plt.plot(utilization_rate, 0.12 / (utilization_rate**1 + 0.05), color="#000000", linestyle=':')

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

# Patches for vector fields
blue_patch = mpatches.Patch(color="#66b3ff", label=patch_labels[0], alpha=0.6)
red_patch = mpatches.Patch(color="#ff6666", label=patch_labels[1], alpha=0.6)

# Lines for travel paths
main_road_1 = mlines.Line2D([], [], color="#33cc33", linestyle='-', label=line_labels[0])
main_road_2 = mlines.Line2D([], [], color="#ffa500", linestyle='--', label=line_labels[1])
detour_1 = mlines.Line2D([], [], color="#999999", linestyle='-.', label=line_labels[2])
detour_2 = mlines.Line2D([], [], color="#000000", linestyle=':', label=line_labels[3])

# Combine all legend handles
handles = [
    blue_patch,
    red_patch,
    main_road_1,
    main_road_2,
    detour_1,
    detour_2,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('quiver_11.pdf', bbox_inches='tight')