
import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
# Data for City A and City B
values_city_a = [8, 7.5, 9, 8.5, 8, 7, 6.5, 6, 7, 8.5]  # City A
values_city_b = [6.5, 6, 5.5, 5, 4.5, 4, 3.5, 3, 4, 5.5]  # City B
labels = [
    "Public Transport",
    "Road Infrastructure",
    "Traffic Management",
    "Safety",
    "Bike Lanes",
    "Pedestrian Walkways",
    "Affordability",
    "Punctuality",
    "Coverage",
    "Customer Service",
]
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values_city_a += values_city_a[:1]
values_city_b += values_city_b[:1]
angles += angles[:1]

# Extracted variables
city_a_label = "Beijing"
city_b_label = "Tokyo"
xticks = angles[:-1]
xticklabels = labels
yticklabels = []
rgrids = [2, 4, 6, 8, 10]
rgrid_labels = ["2", "4", "6", "8", "10"]
title_text = "Transportation Service Quality Comparison: Beijing vs Tokyo"

title_size = 18
title_color = "navy"
title_y = 1.1

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Draw the radar chart
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))
ax.fill(angles, values_city_a, color="darkorange", alpha=0.7)
ax.plot(angles, values_city_a, color="darkorange", linewidth=2, label=city_a_label)
ax.scatter(
    angles[:-1], values_city_a[:-1], color="darkorange", s=75, zorder=5, marker="^"
)
ax.fill(angles, values_city_b, color="purple", alpha=0.7)
ax.plot(
    angles, values_city_b, color="purple", linewidth=2, label=city_b_label
)
ax.scatter(
    angles[:-1], values_city_b[:-1], color="purple", s=75, zorder=5, marker="o"
)

# Add labels to the plot
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels, size=13)

# Add grid lines and labels for the concentric circles
ax.set_yticklabels(yticklabels)
ax.set_rgrids(
    rgrids,
    labels=rgrid_labels,
    angle=225,
    color="gray",
    size=12,
)

# Create legend handles manually
legend_elements = [
    Line2D(
        [0],
        [0],
        color="darkorange",
        linewidth=2,
        marker="^",
        markersize=10,
        label=city_a_label,
    ),
    Line2D(
        [0],
        [0],
        color="purple",
        linewidth=2,
        marker="o",
        markersize=10,
        label=city_b_label,
    ),
]

# Add legend and title
ax.set_title(
    title_text,
    size=title_size,
    color=title_color,
    y=title_y,
)
ax.legend(
    handles=legend_elements,
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    frameon=False,
    ncol=2,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('radar_18.pdf', bbox_inches='tight')
