import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data points
energy_consumed = [100, 400, 300, 400, 500, 600]  # in TWh
renewable_energy_percent = [15, 25, 35, 45, 55, 65]  # in %

labels = [None, "Plant A", None, "Plant B", "Plant C", "Plant D"]
dashed_lines = [(100, 15, 200, 25), (500, 55, 600, 65)]

title = "Energy Consumption vs. Renewable Energy Usage"
xlabel = "Energy Consumed (TWh)"
ylabel = "Renewable Energy Usage (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(8, 5))
plt.scatter(energy_consumed, renewable_energy_percent, color="black", s=100)  # Adjusted marker size and color

# Annotating the data points
for i, label in enumerate(labels):
    plt.annotate(
        label,
        (energy_consumed[i], renewable_energy_percent[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Plotting the dashed lines with correct colors and annotations
plt.plot([100, 200], [15, 25], linestyle="--", color="green")
plt.annotate("+10%", (150, 20), color="green")
plt.plot([100, 300], [15, 35], linestyle="--", color="black")
plt.annotate("Growth A", (200, 25), color="black")
plt.plot([500, 600], [55, 65], linestyle="--", color="orange")
plt.annotate(
    "Plant D",
    (550, 60),
    color="orange",
    textcoords="offset points",
    xytext=(0, 10),
    ha="center",
)

# Setting the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjusting y-axis scale
plt.ylim(10, 70)
plt.yticks([15, 25, 35, 45, 55, 65])
plt.xlim(50, 650)
plt.xticks([100, 200, 300, 400, 500, 600])
plt.grid(True)

# removing the top, left, and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig('scatter_10.pdf', bbox_inches='tight')
