import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
companies = [
    "TechCorp",
    "HealthInc",
    "EduWorks",
    "AutoMotive",
    "GreenEnergy",
    "FinServe",
    "AgriGoods",
    "RetailHub",
    "LogiTrans",
]
market_share = [15, 20, 25, 20, 25, 30, 35, 30, 35]
revenue_growth = [5, 7, 9, 11, 13, 15, 17, 20, 10]
sizes = [500, 1000, 2000, 3000, 3000, 3000, 3000, 3000, 3000]
colors = ["green", "green", "green", "green", "green", "green", "green", "blue", "blue"]
xlabel = "Market Share (%)"
ylabel = "Revenue Growth (%)"
legend_sizes = [500, 1000, 2000, 3000, 4000]
legend_labels = ["Small", "Medium", "Large", "Very Large", "Giant"]
legend_title = "Company Size"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and plot
fig, ax = plt.subplots(figsize=(8, 6))
scatter = ax.scatter(market_share, revenue_growth, s=sizes, c=colors, alpha=0.3)

# Add annotations
for i, company in enumerate(companies):
    ax.annotate(
        company,
        (market_share[i], revenue_growth[i]),
        textcoords="offset points",
        xytext=(0, 0),
        ha="center",
        fontsize=8,
    )

# Customize the axes
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xlim(10, 40)
ax.set_ylim(0, 25)

# Add legend for bubble sizes
for size, label in zip(legend_sizes, legend_labels):
    ax.scatter([], [], c="grey", alpha=0.3, s=size, label=label)

# Adjust the legend to have increased spacing
ax.legend(
    scatterpoints=1,
    frameon=False,
    labelspacing=3,
    handletextpad=-2,
    columnspacing=8,
    title=legend_title,
    fontsize=8,
    loc="upper center",
    bbox_to_anchor=(0.5, 1.3),
    ncol=len(legend_sizes),
)

plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('scatter_12.pdf', bbox_inches='tight')
