
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting (agriculture domain)
test_case_index = [1, 2, 3, 4, 5]
wheat_yield_error = [2, 3, 2.5, 4, 3.5]
corn_yield_error = [4, 3.6, 4, 3, 4]
soybean_yield_error = [1.5, 2.2, 1, 3.2, 5]

# Labels and Titles
xlabel = "Test Case Index"
ylabel = "Average Yield Error"
title = "Average Yield Error for Different Crops"

# Legend labels
wheat_label = "Wheat Yield Error"
corn_label = "Corn Yield Error"
soybean_label = "Soybean Yield Error"

# Plot limits
xlim_values = (1.0, 5.0)
ylim_values = (1, 5)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size in inches to match the original image's dimensions
plt.figure(figsize=(8, 6))

# Plotting the data with adjusted marker sizes
plt.scatter(
    test_case_index,
    wheat_yield_error,
    label=wheat_label,
    color="blue",
    clip_on=False,
    zorder=10,
    marker="^",
    s=150,
)  # Adjusted marker size
plt.scatter(
    test_case_index,
    corn_yield_error,
    label=corn_label,
    clip_on=False,
    zorder=10,
    color="green",
    marker="s",
    s=150,
)  # Adjusted marker size
plt.scatter(
    test_case_index,
    soybean_yield_error,
    label=soybean_label,
    clip_on=False,
    zorder=10,
    color="black",
    marker="o",
    s=100,
)  # Adjusted marker size

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, y=1.1)

# Adding a legend with adjusted order
handles, labels = plt.gca().get_legend_handles_labels()
order = [2, 1, 0]  # Adjusted order to match the reference picture
plt.legend([handles[idx] for idx in order], [labels[idx] for idx in order])

plt.legend(loc="upper right", ncol=3, bbox_to_anchor=(1, 1.08), frameon=False)
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
# Show grid
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('scatter_13.pdf', bbox_inches='tight')
