import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
efficiency = [
    0.1,
    0.35,
    0.55,
    0.7,
    0.9,
    0.25,
    0.45,
    0.6,
]  # Added missing efficiency values
auroc_macro = [
    0.84,
    0.82,
    0.80,
    0.78,
    0.76,
    0.79,
    0.77,
    0.75,
]  # Added missing auroc_macro values
model_names = [
    "BioBERT",
    "BioDistilBERT",
    "BioMobileBERT",
    "TinyBioBERT",
    "Llama-2-7b",
    "PEFT method",
    "Full",
    "LORA",
]
colors = [
    "green",
    "orange",
    "cyan",
    "purple",
    "gray",
    "pink",
    "black",
    "red",
]  # Corrected color for 'Llama-2-7b'
markers = ["o", "o", "o", "o", "o", "o", "o", "x"]  # Corrected marker for 'LORA'
xlabel = "Efficiency"
ylabel = "AUROC macro"
legend_title = "Model name"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 4))

# Plot each point with corresponding color and marker
for i, (eff, auroc, color, marker) in enumerate(
    zip(efficiency, auroc_macro, colors, markers)
):
    ax.scatter(eff, auroc, color=color, marker=marker, label=model_names[i])

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Create legend
legend = ax.legend(title=legend_title, bbox_to_anchor=(1.05, 1), loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()
plt.savefig('scatter_16.pdf', bbox_inches='tight')
