import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for the scatter plot - Technology Trends
years = np.array([2010, 2012, 2014, 2016, 2018, 2020, 2022, 2024, 2026, 2028, 2030, 2032, 2034])
adoption_rate = np.array([56, 21, 44, 32, 67, 23, 45, 56, 78, 23, 45, 23, 45])
investment_amount = np.array([100, 429, 242, 1241, 1234, 500, 941, 234, 600, 234, 423, 734, 123])
xlabel = "Years"
ylabel = "Technology Adoption Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.scatter(years, adoption_rate, c=investment_amount, cmap="viridis")
plt.grid(True)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.colorbar()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('scatter_19.pdf', bbox_inches='tight')
