import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
age_groups = np.array([20, 30, 40, 50, 60, 70, 80])
steps_per_day = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(age_groups)))
    + np.random.normal(0, 0.1, len(age_groups)),
    0.2,
    0.9,
)
heart_rate = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(age_groups)))
    + np.random.normal(0, 0.1, len(age_groups)),
    0.3,
    1,
)
cholesterol_levels = np.clip(
    np.sin(np.linspace(0, 1 * np.pi, len(age_groups)))
    + np.random.normal(0, 0.1, len(age_groups)),
    0.3,
    0.8,
)
blood_pressure = np.clip(
    np.cos(np.linspace(0, 1.5 * np.pi, len(age_groups)))
    + np.random.normal(0, 0.05, len(age_groups)),
    0.4,
    0.9,
)
titles = ["Steps per Day vs Cholesterol Levels", "Heart Rate vs Blood Pressure"]
figure1_scatter_labels = ["Steps per Day", "Cholesterol Levels"]
figure2_scatter_labels = ["Heart Rate", "Blood Pressure"]
xlabel = "Age Groups (years)"
ylabel = "Measurements (normalized)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# The first subplot plots Steps per Day and Cholesterol Levels
ax1.scatter(
    age_groups,
    steps_per_day,
    color="cyan",
    label=figure1_scatter_labels[0],
    marker="o",
    s=80,
    edgecolor="black",
)
ax1.scatter(
    age_groups,
    cholesterol_levels,
    color="blue",
    label=figure1_scatter_labels[1],
    marker="s",
    s=80,
    edgecolor="black",
)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(loc="upper right")

# The second subplot plots Heart Rate and Blood Pressure
ax2.scatter(
    age_groups,
    heart_rate,
    color="magenta",
    label=figure2_scatter_labels[0],
    marker="^",
    s=80,
    edgecolor="black",
)
ax2.scatter(
    age_groups,
    blood_pressure,
    color="red",
    label=figure2_scatter_labels[1],
    marker="d",
    s=80,
    edgecolor="black",
)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.set_ylabel(ylabel, fontsize=12)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('scatter_21.pdf', bbox_inches='tight')
