import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Australia",
    "Middle East",
    "Central America",
    "Antarctica",
]
values = {
    "Efficiency": [85, 78, 90, 65, 70, 80, 75, 60, 50],
    "Cost": [60, 55, 70, 40, 50, 65, 45, 35, 30],
    "Environmental Impact": [30, 25, 40, 20, 35, 50, 45, 25, 15],
    "Availability": [75, 80, 85, 60, 65, 70, 55, 50, 45],
    "Public Acceptance": [65, 60, 70, 50, 55, 75, 40, 35, 30],
}
colors = ["blue", "orange", "green", "red", "purple"]
xlabel = "Regions"
ylabel = "Score"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots 2x2
fig, axs = plt.subplots(2, 2, figsize=(10, 10), sharey=True)
axes = axs.flatten()

# Plot each category
for ax, (category, color) in zip(axes, zip(values.keys(), colors)):
    ax.scatter(
        regions,
        values[category],
        color=color,
        label=category,
        s=100,
        edgecolor="black",
        alpha=0.6,
        marker="o",
    )
    ax.set_title(category)
    ax.set_xticks(regions)
    ax.set_xticklabels(regions, rotation=45, ha="right")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# Enhance style
for ax in axes:
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.grid(True, linestyle="--", alpha=0.5)
    ax.set_ylim(0, 100)  # Ensure all plots have the same y-axis limits

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('scatter_23.pdf', bbox_inches='tight')
