import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Generate data
years = np.linspace(2010, 2018, 9)
product1_revenue = years * np.random.uniform(1.0, 1.5, 9) + np.random.normal(0, 5, 9)
product2_revenue = years * np.random.uniform(0.8, 1.2, 9) + np.random.normal(0, 5, 9)
product3_revenue = years * np.random.uniform(0.5, 1.0, 9) + np.random.normal(0, 5, 9)

sizes = np.linspace(50, 150, 9)  # Define marker sizes

# Define color gradients for visual appeal
colors = ["deepskyblue", "magenta", "limegreen"]
titles = ["Revenue Growth - Product 1", "Revenue Growth - Product 2", "Revenue Growth - Product 3"]
xlabel = "Year"
ylabel = "Revenue (in millions)"
cbar_label = "Year Scale"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes objects
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Plot scatter plots
for ax, revenue, color, title in zip(axs, [product1_revenue, product2_revenue, product3_revenue], colors, titles):
    sc = ax.scatter(
        years,
        revenue,
        s=sizes,
        c=years,
        cmap="viridis",
        alpha=0.6,
        edgecolor="black",
    )
    ax.plot(
        years, revenue, color=color, linestyle="--", alpha=0.6
    )  # Connect points with dashed lines
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_ylim(min(revenue) - 10, max(revenue) + 10)

# Add color bars to each subplot for color mapping explanation
for ax in axs:
    cb = plt.colorbar(sc, ax=ax, orientation="vertical")
    cb.set_label(cbar_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlapping
plt.tight_layout()


# Display the plot
plt.savefig('scatter_24.pdf', bbox_inches='tight')
