
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
clusters = {
    "downtown": np.array([[0.8, 2.7], [1.4, 1.7], [2.2, 0.7], [2.7, 1.8], [3.6, 2.4], [1.3, 0.6], [2.1, 1.6], [1.6, 2.8], [1.0, 1.4], [1.8, 1.0]]),
    "suburbs": np.array([[6.1, 5.2], [5.9, 4.5], [4.6, 4.9], [5.8, 5.4], [6.6, 4.6], [4.4, 4.5], [4.8, 5.1], [3.8, 5.0], [5.6, 5.2], [4.9, 4.6], [3.8, 4.3], [4.6, 5.2], [4.4, 5.7], [6.1, 3.4], [5.3, 5.6]]),
    "industrial_area": np.array([[-1.6, 4.6], [-1.1, 4.7], [-1.3, 3.3], [-0.9, 6.1], [-1.8, 3.5], [-0.4, 4.4], [-0.9, 4.7], [-0.3, 5.7], [-1.7, 3.6], [-2.6, 5.6], [-2.1, 4.5], [-1.6, 4.9], [-2.9, 5.1], [-0.4, 5.1], [-1.3, 5.1], [-0.6, 2.2], [-0.1, 5.4], [-1.6, 4.6], [-0.5, 4.9], [-3.0, 7.1]]),
    "business_district": np.array([[2.9, -1.9], [2.3, -1.5], [3.3, -2.3], [2.0, -1.9], [3.6, -1.7], [2.4, -2.5], [4.3, -3.1], [2.8, -1.8], [3.1, -2.4], [2.6, -2.4], [1.7, -1.3], [2.9, -2.8], [3.6, -2.7], [1.7, -3.2], [3.6, -2.6]]),
    "residential_area": np.array([[-2.1, -2.0], [-3.1, -3.7], [-2.3, -2.9], [-2.0, -3.1], [-2.0, -2.9], [-2.7, -3.1], [-1.7, -3.2], [-3.2, -3.1], [-2.1, -1.2], [-2.7, -2.1]]),
    "outskirts": np.array([[0.8, 4.1], [0.7, 4.1], [-1.6, 5.6], [-0.8, 5.5], [0.3, 5.6], [1.1, 4.8], [0.3, 4.1], [0.6, 4.7], [0.4, 5.1], [1.2, 5.2], [0.2, 4.0], [1.4, 4.7], [0.4, 4.9], [-0.8, 5.0], [0.5, 5.6], [0.9, 5.0], [1.0, 5.2], [0.0, 5.1], [0.1, 4.6], [0.3, 4.1], [0.6, 4.2], [1.2, 4.8], [0.0, 5.4], [0.7, 4.0], [0.1, 5.6]]),
}


# Colors for each cluster (replace with actual colors)
colors = {
    "downtown": "red",
    "suburbs": "blue",
    "industrial_area": "green",
    "business_district": "purple",
    "residential_area": "orange",
    "outskirts": "yellow",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(5, 5))
for cluster, data in clusters.items():
    plt.scatter(data[:, 0], data[:, 1], c=colors[cluster], alpha=0.5)

# Remove axes and grid
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('scatter_4.pdf', bbox_inches='tight')
