import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data points for each group
solar = [(50, 950), (100, 800)]
wind = [(70, 850), (120, 700)]
hydro = [(60, 450), (110, 400)]
nuclear = [(80, 600), (130, 550)]
coal = [(90, 250), (140, 200)]
gas = [(150, 300), (200, 100)]
labels = ["Solar", "Wind", "Hydro", "Nuclear", "Coal", "Gas"]
xlabel = "Energy Consumption (MWh)"
ylabel = "Cost (USD)"
title = "Scatter Plot of Energy Consumption vs Cost"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(6, 6))

# Plot each group with different color and marker
ax.scatter(*zip(*solar), color="blue", label=labels[0])
ax.scatter(*zip(*wind), color="cyan", label=labels[1])
ax.scatter(*zip(*hydro), color="red", label=labels[2])
ax.scatter(*zip(*nuclear), color="green", label=labels[3])
ax.scatter(*zip(*coal), color="magenta", label=labels[4], marker="x")
ax.scatter(*zip(*gas), color="orange", label=labels[5])

# Add legend
ax.legend(loc="upper right")

# Add labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig('scatter_5.pdf', bbox_inches='tight')
