
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================

ar_speed = np.array([55, 60, 58, 62, 59, 45, 57, 50, 52, 61, 63, 64, 58, 60,
                     62, 61, 66, 54, 60, 48, 40, 59, 61, 49, 65])
ar_fuel_efficiency = np.array([22, 25, 24, 28, 26, 21, 23, 19, 18, 24, 25, 29, 27, 23,
                               22, 21, 20, 19, 30, 25, 24, 23, 27, 20, 26])
de_speed = np.array([50, 52, 51, 53, 54, 48, 55, 52, 51, 53, 54, 52,
                     50, 49, 48, 51, 56, 48, 53, 52, 50, 48, 47, 54,
                     52])
de_fuel_efficiency = np.array([20, 19, 20, 21, 22, 18, 25, 24, 16, 27, 28, 26, 23, 19,
                               25, 22, 28, 24, 25, 23, 26, 22, 27, 24, 24])
fr_speed = np.array([48, 45, 47, 50, 46, 49, 52, 44, 50, 48, 46, 50,
                     44, 49, 51, 50, 49, 51, 50, 52, 49, 45, 50, 48,
                     44])
fr_fuel_efficiency = np.array([21, 20, 23, 22, 24, 18, 22, 19, 20, 19, 23, 21,
                               22, 20, 18, 17, 22, 21, 19, 25, 22, 17, 23, 16,
                               20])
he_speed = np.array([60, 65, 58, 55, 60, 59, 67, 53, 52, 60, 59, 70, 65, 61,
                     52, 66, 55, 50, 68, 64, 67, 63, 66, 58, 55])
he_fuel_efficiency = np.array([30, 27, 28, 29, 31, 29, 24, 28, 23, 31, 25, 27, 32, 28,
                               35, 27, 30, 29, 27, 32, 29, 33, 33, 37, 34])

# Extracted variables for the transportation domain
scatter_label_ar = "AR"
scatter_label_de = "DE"
scatter_label_fr = "FR"
scatter_label_he = "HE"
xlabel = "Speed (km/h)"
ylabel = "Fuel Efficiency (km/l)"

legend_title = "Legend"
ncol_legend = 4
bbox_anchor_legend = (0.5, 1.1)
loc_legend = "upper center"
frameon_legend = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(8, 8))
plt.scatter(ar_speed, ar_fuel_efficiency, color="blue", alpha=0.5, label=scatter_label_ar)
plt.scatter(de_speed, de_fuel_efficiency, color="magenta", alpha=0.5, label=scatter_label_de)
plt.scatter(fr_speed, fr_fuel_efficiency, color="yellow", alpha=0.5, label=scatter_label_fr)
plt.scatter(he_speed, he_fuel_efficiency, color="green", alpha=0.5, label=scatter_label_he)
plt.tick_params(axis="both", length=0)
# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.legend(
    title=legend_title, ncol=ncol_legend, bbox_to_anchor=bbox_anchor_legend, loc=loc_legend, frameon=frameon_legend
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig('scatter_8.pdf', bbox_inches='tight')
