# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [24.5, 22.0, 16.3, 12.8, 10.2, 8.0, 6.2]
company_labels = [
    "Toyota\n24.5%",
    "Volkswagen\n22.0%",
    "Ford\n16.3%",
    "Honda\n12.8%",
    "General Motors\n10.2%",
    "Hyundai\n8.0%",
    "Others\n6.2%",
]
plot_title = 'Global Market Share of Leading Car Manufacturers'


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=company_labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18},
    ec="white",
)

# Add title
plt.title(plot_title, fontsize=22)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('tree_12.pdf', bbox_inches='tight')