# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [30.00, 27.00, 20.00, 8.00, 7.50, 7.50]
brand_labels = [
    "Patagonia\n30.00%",
    "The North Face\n27.00%",
    "Columbia\n20.00%",
    "Arc'teryx\n8.00%",
    "Marmot\n7.50%",
    "Others\n7.50%",
]
plot_title = "Market Share of Outdoor Apparel Brands"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
color_palette = ["#1F77B4", "#AEC7E8", "#FF7F0E", "#FFBB78", "#2CA02C", "#98DF8A"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=brand_labels,
    color=color_palette,
    alpha=0.7,
    text_kwargs={"fontsize": 18},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(plot_title, fontsize=22)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('tree_13.pdf', bbox_inches='tight')