# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data - Data Science Fields Distribution
field_sizes = [38, 22, 18, 12, 6, 4]
field_labels = ["Data Science - 38%", "Machine Learning - 22%", "Data Engineering - 18%", "Visualization - 12%", "NLP - 6%", "Big Data - 4%"]
plot_title = "Data Science Fields Distribution"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
field_colors = ["#FFD700", "#FF6347", "#4682B4", "#32CD32", "#FF69B4", "#BA55D3"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

# Create a treemap
squarify.plot(
    sizes=field_sizes,
    label=field_labels,
    color=field_colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "black"},
    edgecolor="white",  # Improved border visibility
    linewidth=2 # Added edge line width for better visuals
)

# Set plot title
plt.title(plot_title, fontsize=18, color='black', weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_15.pdf', bbox_inches='tight')