# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [40, 25, 15, 10, 5, 5]
brand_labels = [
    "JBL\n40%",
    "Sony\n25%",
    "Bose\n15%",
    "Sonos\n10%",
    "Harman Kardon\n5%",
    "Others\n5%"
]
plot_title = "Market Share of Global Speaker Brands"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
brand_colors = ["#4A90E2", "#50E3C2", "#F5A623", "#9013FE", "#B8E986", "#D0021B"]
# Create a figure with the specified size
fig = plt.figure(figsize=(6, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=brand_labels,
    color=brand_colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "white"},
    ec="white",
)

# Set the title
plt.title(plot_title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_17.pdf', bbox_inches='tight')