# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [35, 28, 18, 12, 7]
brand_labels = [
    "Ray-Ban\n35%",
    "Oakley\n28%",
    "Persol\n18%",
    "Prada\n12%",
    "Gucci\n7%"
]
plot_title = "Market Share of Global Eyewear Brands"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
brand_colors = ["#8FBC8F", "#FFD700", "#D2B48C", "#6B8E23", "#CD853F"]
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=brand_labels,
    color=brand_colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "black"},
    pad=True,
    ec="black",
)

# Set title
plt.title(plot_title, fontsize=16)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_18.pdf', bbox_inches='tight')