import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.30, 0.20, 0.15, 0.10, 0.15, 0.10]
labels = [
    "Solar\n30%",
    "Wind\n20%",
    "Hydro\n15%",
    "Biomass\n10%",
    "Geothermal\n15%",
    "Other\n10%",
]
colors = ["#FFD700", "#ADFF2F", "#00CED1", "#8B4513", "#FF8C00", "#D3D3D3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "black"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig('tree_2.pdf', bbox_inches='tight')
