import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [27.0, 24.2, 16.3, 11.4, 10.2, 8.9]
labels = [
    "Oil\n27.0%",
    "Coal\n24.2%",
    "Natural Gas\n16.3%",
    "Hydropower\n11.4%",
    "Nuclear\n10.2%",
    "Renewables\n8.9%",
]
colors = ["#FFDDC1", "#F7A072", "#FF9B71", "#FFD571", "#EDE574", "#8CBA80"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18},
    ec="black",
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('tree_3.pdf', bbox_inches='tight')
